<?php
namespace MyApp;

use Ratchet\MessageComponentInterface;
use Ratchet\ConnectionInterface;
use Ratchet\WebSocket\WsServerInterface;
use MyApp\Init;

class Desc implements MessageComponentInterface
{
    public $clients;
    public $init;
    public $debug = false;

    public function __construct()
    {
        $this->clients = new \SplObjectStorage;
        echo $this->SetLogTxt("Websocket server started.\r\n\r\n");
    }

    public function onOpen(ConnectionInterface $conn)
    {
        $this->clients->attach($conn);
        $idTag = $this->ReturnidTag($conn);
        $init = new Init();
        $isAuthorized = false;

        $chargerExists = $init->chargerExistsInDatabase($idTag);

        if (!$chargerExists) {
            echo $this->SetLogTxt($idTag . " - Charger not in database\r\n\r\n");
            $this->onClose($conn);
            return;
        }

        $authHeader = $conn->httpRequest->getHeader('Authorization');
        if (isset($authHeader[0]) && !empty($authHeader[0])) {
            $authToken = substr($authHeader[0], 6);
            if ($init->SelectConected($idTag, $authToken)) {
                // echo $this->SetLogTxt($idTag . " - is authorized with Basic Auth\r\n\r\n");
                $isAuthorized = true;
            } else {
                // echo $this->SetLogTxt($idTag . " - failed Basic Auth\r\n\r\n");
                $this->onClose($conn);
                return;
            }
        } else {
            echo $this->SetLogTxt($idTag . " - is authorized without Basic Auth\r\n\r\n");
            $isAuthorized = true;
        }

        if ($isAuthorized) {
            $this->init = $init;

            if (count($this->clients) > 1) {
                $allconn = [];
                foreach ($this->clients as $client) {
                    $allconn[$client->resourceId] = $this->ReturnidTag($client);
                }

                $result = array_count_values($allconn);
                foreach ($result as $key => $value) {
                    if ($key == $this->ReturnidTag($conn) && $value > 1) {
                        foreach ($allconn as $resourceId => $idTag) {
                            if ($idTag == $this->ReturnidTag($conn) && $resourceId != $conn->resourceId) {
                                foreach ($this->clients as $client) {
                                    if ($idTag == $this->ReturnidTag($client)) {
                                        echo $idTag . ' going to be removed ' . $resourceId . PHP_EOL . PHP_EOL;
                                        $this->onClose($client);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }


    public function onMessage(ConnectionInterface $from, $msg)
    {
        foreach ($this->clients as $client)
        {
            if ($from === $client)
            {
                if(is_array(json_decode($msg)))
                {
                    $init = new Init();
                    // echo $this->SetLogTxt('SC - '.$this->ReturnidTag($from).' - '.date('H:i:s').' '.$msg.PHP_EOL.PHP_EOL);
                    $respon = $init->Status(json_decode($msg), $this->ReturnidTag($from));
                    $init->up_command($msg, $this->ReturnidTag($from)); //Let's record history. What we received from the station

                    if($respon != NULL)
                    {
                        $client->send($respon);
                        // echo $this->SetLogTxt('CS - '.$this->ReturnidTag($from).' - '.date('H:i:s').' '.$respon.PHP_EOL.PHP_EOL);
                        $init->up_command($respon, $this->ReturnidTag($from)); //Let's record history. What we received from the station
                    }
                } //END if is_array
            }//END $from === $client
        }// END foreach
    }

    public function onMessageTimer(ConnectionInterface $from, $msg)
    {
        foreach ($this->clients as $client)
        {
            if ($from === $client)
            {
                $client->send($msg);
            }
        }
    }

    public function onClose(ConnectionInterface $conn)
    {
        $this->clients->detach($conn);
        $conn->close();
        echo $this->SetLogTxt("The connection is closed to ".$this->ReturnidTag($conn)."\r\n\r\n");
    }

    public function onError(ConnectionInterface $conn, \Exception $e)
    {
        echo $this->SetLogTxt("Error: {$e->getMessage()}\r\n");
        $conn->close();
    }

    //Get station ID
    public function ReturnidTag($conn)
    {
        $request = $conn->httpRequest;
        $pieces = explode("/", $request->getUri()->getPath());
        $reversed = array_reverse($pieces);
        return $reversed[0];
    }

    //Write logs
    public function SetLogTxt($record)
    {
        if(!$this->debug) {
            return;
        }
        $filename = __DIR__.'/server.log';
        file_put_contents($filename, $record, FILE_APPEND | LOCK_EX);
        return $record;
    }

}
