<?php
namespace MyApp;

date_default_timezone_set("Africa/Accra");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('config/define.php');

class Init
{
    private $db;
    private $idTag;
    private $connectorIdS = 0;
    private $type;
    private $user_id = 1;
    private $session;
    private $pricing;
    private $subscription;
    private $configuration;
    public $debug_mode = false; // Set to true only when debugging issues

    function __construct()
    {
        $this->db = new MySQL(DB_HOST, DB_PORT, DB_USER, DB_PASS, DB_NAME);
        $this->session = new Session($this->db);
        $this->pricing = new Pricing($this->db);
        $this->subscription = new Subscription($this->db);
        $this->configuration = new Configuration($this->db);
    }

    // Allows us to connect or not
    public function SelectConected($idTag, $access)
    {
        if(isset($idTag) && $idTag != NULL)
        {
            $res = $this->db->row("SELECT * FROM my_charger WHERE idTag = '{$idTag}'  ");

            if($res != NULL && $res['id'] > 0 && $res['idTag'].':'.$res['password'] == base64_decode($access))
            {
                $this->idTag = $res['idTag'];
                return true;
            }
            else
                return false;
        }
        else
            return false;
    }

    public function chargerExistsInDatabase($idTag)
    {
        if(empty($idTag)) return false;

        $res = $this->db->row("SELECT id FROM my_charger WHERE idTag = '{$idTag}'");
        return ($res != NULL && isset($res['id']) && $res['id'] > 0);
    }

    //Ping the base my_set_command and if the commands are sent to the station and the command itself is deleted
    public function SetCommand($idTag)
    {
        $res = $this->db->row("SELECT * FROM my_set_command WHERE idTag = '{$idTag}' order by id DESC ");
        if($res != false)
        {
            $us = $this->db->row("SELECT * FROM `my_user` WHERE `mobile` = '{$res['user_id']}' ");
            if ($us != false)
            {
                $res['user_id'] = $us['id'];
            }
            else
            {
                $res['user_id'] = 1;
            }
            $this->db->query("DELETE FROM `my_set_command` WHERE id = '".$res['id']."'; ");
            return $res;
        }
        else {return false;}
    }



    //We write to the temporary base which connector was launched
    public function UpConnectorCommand($idTag, $connector_id = 0)
    {
        $heartbeat = time();
        $this->db->query(  "DELETE FROM `my_set_command_connector` WHERE  idTag = '{$idTag}' "  );
        $this->db->query(  "INSERT INTO `my_set_command_connector` (`idTag`, `connectorId`, `heartbeat`) VALUES ('{$idTag}', '{$connector_id}', '{$heartbeat}')"   );
    }


    //Write to the temporary base who launched the command
    public function UpUserCommand($idTag, $user_id = 0)
    {
        $heartbeat = time();

        if($user_id > 0)
        {
            $res = $this->db->row("SELECT * FROM my_set_command_buffer WHERE idTag = '{$idTag}' ");
            if($res)
            {
                $id = $res['id'];
                $this->db->query(  "UPDATE `my_set_command_buffer` SET `user_id` = '{$user_id}' WHERE id = '{$id}'; " );
            }
            else {
                $this->db->query(  "INSERT INTO `my_set_command_buffer` (`idTag`, `user_id`, `heartbeat`) VALUES ('{$idTag}', '{$user_id}', '{$heartbeat}')"   );
            }
        }

    }


    //Get the user id who last ran the command on the current station
    public function UserID($idTag)
    {
        $res = $this->db->row("SELECT user_id FROM my_set_command_buffer WHERE idTag = '{$idTag}' ");
        if(isset($res['user_id']) && $res['user_id'] > 0)
        {
            return $res['user_id'];
        }
        else {
            return 1;
        }
    }


    //Get the connector id who last ran the command on the current station
    public function ConnectorSID($idTag)
    {
        $res = $this->db->row("SELECT connectorId FROM my_set_command_connector WHERE idTag = '{$idTag}' ");
        return $res['connectorId'];
    }


    //Write the history of commands sent by handles to the database
    public function up_command($data, $idTag)
    {
        $type = json_decode($data);
        $heartbeat = time();

        if(isset($type[2]) && $type[0] == 2)
        {
            $SetType = $this->SetType($type[2]);

            if($SetType == '5' || $SetType == '7') {
                //StopTransaction //RemoteStopTransaction
                $this->handleRemoteStopTransaction($type);
            }

            $dataString = is_string($data) ? $data : json_encode($data);
            $dataString = addslashes($dataString); // Escape for SQL
            $this->db->query(  "INSERT INTO `my_set_history` (`idTag`, `type`, `typeText`, `text`, `heartbeat`) VALUES ('{$idTag}', '{$SetType}', '{$type[2]}', '{$dataString}', '{$heartbeat}')"   );
        }
        if($type[0] == 3)
        {
            $search = '[2,"'.$type[1];
            $res = $this->db->row("   SELECT * FROM `my_set_history` WHERE `text` LIKE '%{$search}%' AND idTag = '{$idTag}'  ORDER BY `id` DESC ");
            if($res)
            {
                $this->type = $res['typeText'];
            }

            $SetType = $this->SetType($this->type);
            $dataString = is_string($data) ? $data : json_encode($data);
            $typeString = is_string($this->type) ? $this->type : json_encode($this->type);

            // Escape strings for SQL insertion
            $dataString = addslashes($dataString);
            $typeString = addslashes($typeString);

            $this->db->query(  "INSERT INTO `my_set_history` (`idTag`, `type`, `typeText`, `text`, `heartbeat`) VALUES ('{$idTag}', '{$SetType}', '{$typeString}', '{$dataString}', '{$heartbeat}')"   );
        }
        //If the command is to start a transaction, then assign a connector number


        if(isset($type[2]) && $type['2'] == 'RemoteStartTransaction')
        {
            $this->UpConnectorCommand($idTag, $type[3]->connectorId);
        }
    }


    //We receive some data from the station and process them through switch - we answer
    public function Status($data, $idTag = '')
    {
        $this->idTag = $idTag;
        $t = explode(" ",microtime());
        $currentTime = date("Y-m-d\TH:i:s",time()).substr((string)$t[0],1,4).'Z';
        if (isset($data[2]) && !is_object($data[2]))
        {
            $this->type = $data[2];

            $user_id = $this->UserID($idTag);

            switch ($data[2])
            {
                case 'BootNotification':
                    $boot = new \stdClass();
                    $this->SetBootNotification($data);
                    $boot->currentTime = $currentTime;
                    $boot->interval = 60;
                    $boot->status = 'Accepted';
                    $BootNotification = json_encode(  array(0 =>3,1 => $data[1], $boot ));
                    return $BootNotification;
                    break;

                case 'StatusNotification':
                    $this->SetStatus($data);
                    $StatusNotification = json_encode(  array(0 =>3,1 => $data[1], new \stdClass() ));
                    return $StatusNotification;
                    break;

                case 'Heartbeat':
                    $head = new \stdClass();
                    $head->currentTime = $currentTime;
                    $Heartbeat = json_encode(  array(0 =>3,1 => $data[1], $head ));
                    $this->SetHeartbeat($idTag, $data);
                    return $Heartbeat;
                    break;

                case 'StartTransaction':
                    //Create a transaction number using a more reasonable approach
                    $transactionId = $this->generateTransactionId();

                    $set = new \stdClass();
                    $set->parentIdTag = '';
                    $set->status = $this->StartTransactionStatus($idTag, $data);
                    $StartTransaction = json_encode(  array(0 => 3, 1 =>  $data[1], array('idTagInfo' => $set, 'transactionId' => $transactionId ) ));
                    $times = time();

                    if($set->status == 'Accepted')
                    {
                        $this->db->query("INSERT INTO my_user_start_transaction (user_id, transactionId, TimeCompletion) VALUES ('".$user_id."', '".$transactionId."', '".$times."');");
                        $this->session->setTransactionIdForSession($transactionId, $idTag, $data[3]->connectorId);
                        $this->session->setSessionStarting($transactionId, $idTag, $data[3]->connectorId);
                        $this->session->linkUserToCompany($idTag, $user_id);
                        return $StartTransaction;
                    }
                    else
                    {
                        $StopTransaction = json_encode(  array(0 => 2, 1 => ''.rand(1000000,9999999).'', 2 => 'RemoteStopTransaction', array('transactionId' => $transactionId) ));
                        $times = time();
                        $this->db->row("INSERT INTO `my_set_command` (`idTag`, `user_id`, `type`, `text`, `heartbeat`) VALUES ('{$idTag}', '{$user_id}', 'RemoteStopTransaction', '{$StopTransaction}', '{$times}')");
                        $this->session->endSessionIfExists($transactionId, $idTag, $data[3]->connectorId);
                    }
                    break;

                case 'MeterValues':
                    $this->MeterValues($idTag, $data);
                    $this->SetHeartbeat($idTag, $data);
                    $MeterValues = json_encode(  array(0 => 3, 1 => $data[1], new \stdClass() ));
                    return $MeterValues;
                    break;

                case 'StopTransaction':
                    $set = new \stdClass();
                    $set->parentIdTag = '';
                    $set->status = 'Accepted';
                    $StopTransaction = json_encode(  array(0 => 3, 1 =>  $data[1], array('idTagInfo' => $set) ));
                    if (isset($data[3]->transactionId)) {
                        $this->session->endSessionIfExists($data[3]->transactionId);
                    }
                    //$this->SetStopTransaction($idTag, $data, $user_id); //We take extra money if there is a difference
                    return $StopTransaction;
                    break;

                case 'Authorize':
                    $Auth = new \stdClass();
                    $Auth->status =  $this->AuthorizeStatus($idTag, $data);;
                    $Authorize = json_encode(  array(0 => 3, 1 =>  $data[1], array('idTagInfo' => $Auth ) ));
                    return $Authorize;
                    break;

                case 'FirmwareStatusNotification':
                    $FirmwareStatusNotification = json_encode(  array(0 =>3,1 => $data[1], new \stdClass() ));
                    return $FirmwareStatusNotification;
                    break;

                case 'DiagnosticsStatusNotification':
                    $FirmwareStatusNotification = json_encode(  array(0 =>3,1 => $data[1], new \stdClass() ));
                    return $FirmwareStatusNotification;
                    break;

                case 'SecurityEventNotification':
                    $SecurityEventNotification = json_encode(  array(0 =>3,1 => $data[1], new \stdClass() ));
                    return $SecurityEventNotification;
                    break;
                case 'ChangeConfiguration':
                    $key = $data[3]->key ?? null;
                    $value = $data[3]->value ?? null;

                    if ($key) {
                        $this->db->query("
                            UPDATE my_charger_configuration
                            SET value = '{$value}', updated_at = NOW()
                            WHERE idTag = '{$idTag}' AND `key` = '{$key}'
                        ");

                        $resp = [
                            3, // success response
                            $data[1], // same messageId as sent
                            new \stdClass()
                        ];
                    } else {
                        $resp = [4,
                            $data[1], // this should match original request's messageId
                            'ProtocolError',
                            'Invalid Configuration Key/Value',
                            (object)['errorMsg' => 'Missing key or value']
                        ];
                    }
                    return json_encode($resp);
                    break;

                case 'DataTransfer':
                    $messageId = $data[3]->messageId ?? null;
                    $dataStr = $data[3]->data ?? null;

                    if ($messageId === 'vehicleMAC' && $dataStr) {
                        return $this->handleVehicleMACDataTransfer($idTag, $data, $dataStr);
                    }

                    // Default response for other DataTransfer messages
                    return json_encode([
                        3,
                        $data[1],
                        ['status' => 'Accepted']
                    ]);
                    break;

                default:
                    break;
            }
        } else if (isset($data[2])) {
//            $this->writeLog('response here');
            $this->writeLog(json_encode($data));
            $this->type = $data[2];

            $user_id = $this->UserID($idTag);

            // GET NOTIFICATION RESPONSE AND SAVE TO DB
            if ($data[0] == 3 && isset($data[2]->configurationKey)) {
                $this->writeLog('Charger Config here');
                $this->writeLog(json_encode($data));
                $this->configuration->setConfigurationFromCharger($idTag, $data);
                return json_encode([3, $data[1], new \stdClass()]);
            }
        }
    }

    public function SetStopTransaction($idTag, $data, $user_id)
    {
        $this->session->updateSessionStatus($data[3]->transactionId);

        // Get meter start from StartTransaction
        $start_tx = $this->db->row("
            SELECT text
            FROM my_set_history
            WHERE idTag = '{$idTag}' AND type = 4 AND text LIKE '%StartTransaction%' AND text LIKE '%{$data[3]->transactionId}%'
            ORDER BY id ASC
            LIMIT 1
        ");

        if (!$start_tx) {
            return;
        }

        $start_data = json_decode($start_tx['text']);
        $meter_start_stop = ($data[3]->meterStop - $start_data[3]->meterStart) / 1000; // Convert to kWh

        // Get price from sessions
        $session = $this->db->row("
            SELECT price
            FROM my_sessions
            WHERE transactionId = '{$data[3]->transactionId}'
        ");

        $price = $session['price'] ?? 3.5; // Default price if not set
        $money = $meter_start_stop * $price;

        // Get user's current balance
        $user = $this->db->row("SELECT balanse FROM my_user WHERE id = '{$user_id}'");
        $new_balance = $user['balanse'] - $money;

        // Record the operation
        $this->db->query("
            INSERT INTO my_user_operations
            (user_id, transactionId, operationTime, MeterValues, money, user_balanse, type)
            VALUES
            ('{$user_id}', '{$data[3]->transactionId}', '".time()."', '{$meter_start_stop}', '{$money}', '{$new_balance}', 'charger')
        ");

        // Update user balance
        $this->db->query("UPDATE my_user SET balanse = '{$new_balance}' WHERE id = '{$user_id}'");
    }

    //We exclude the possibility of recording new MeterValues
    public function ChekTransactionId($data, $idTag)
    {
        $respons = true;
        $res = $this->db->row("SELECT operationTime FROM my_user_operations WHERE transactionId = '".$data[3]->transactionId."' order by id DESC ");
        if($res)//Check for transactionId records
        {
            if($res['operationTime'] < (time() - 86400)  )
            {
                $respons = false;
            }
        }
        return $respons;
    }

    //Allow start of charging station by RFID card number
    public function StartTransactionStatus($idTag, $data) {
//        $this->writeLog('StartTransaction: Starting with RFID ' . $data[3]->idTag);

        if (!$this->isRFIDAuthorized($idTag, $data[3]->idTag)) {
            $this->writeLog('StartTransaction: RFID not authorized');
            return 'Blocked';
        }

        return 'Accepted';
    }

    //Allow charging station authorization by RFID card number
    public function AuthorizeStatus($idTag, $data) {
//        $this->writeLog('Authorize: Checking RFID ' . $data[3]->idTag);
        return $this->isRFIDAuthorized($idTag, $data[3]->idTag) ? 'Accepted' : 'Blocked';
    }

    //Write the firmware version
    public function SetBootNotification($data)
    {
        $this->db->query("UPDATE my_charger SET firmwareVersion = '{$data[3]->firmwareVersion}' WHERE idTag = '{$this->idTag}';  ");
    }

    //Record the heartbeat time in the Heartbeat method
    public function SetHeartbeat($idTag, $data)
    {
        $time = time();
        $this->db->row("UPDATE `my_charger` SET `heartbeat` = '{$time}' WHERE idTag = '{$idTag}';  ");
    }

    //Write the status of the stations in the StatusNotification method
    public function SetStatus($data)
    {
        $res = $this->db->row("SELECT * FROM `my_charger_connectorId` WHERE `idTag` LIKE '{$this->idTag}'  ");
        if($res == false)
        {
            $this->connectorId($data);
        }
        else
        {
            $osp = $this->db->row("SELECT * FROM `my_charger_connectorId` WHERE `idTag` LIKE '{$this->idTag}'  AND connectorId = '{$data[3]->connectorId}' ");
            if($osp == false)
            {
                $this->connectorId($data);
            }
            else
            {
                $this->db->query("UPDATE my_charger_connectorId SET status = '{$data[3]->status}', errorCode = '{$data[3]->errorCode}'  WHERE idTag = '{$this->idTag}' AND connectorId = '{$data[3]->connectorId}'  ;  ");
            }
        }
    }

    //Write a fake 0, MeterValues
    public function SetFalseMeterValues($idTag, $user_id, $transactionId, $value = 0)
    {
        $times = time();
        $user_id = $this->UserID($idTag);
        $connector_id = $this->ConnectorSID($idTag);

        $this->db->query(  "INSERT INTO `my_charger_meter` (`userId`, `idTag`, `connectorId`, `transactionId`, `timestamp`) VALUES ('{$user_id}', '{$idTag}', '{$connector_id}', '{$transactionId}', '{$times}' )"   );

        $parentId = $this->db->lastInsertId();

        $this->db->query(  "INSERT INTO `my_charger_meter_type` (`idTag`, `transactionId`, `parentId`, `value`, `measurand`, `phase`, `unit`) VALUES ('{$idTag}', '{$transactionId}', '{$parentId}', {$value}, 'Energy.Active.Import.Register', NULL, 'Wh')"   );

        return $this->db->lastInsertId();
    }


    //Updating connector information
    public function connectorId($data)
    {
        $this->db->query(  "INSERT INTO `my_charger_connectorId` (`idTag`, `connectorId`, `status`, `errorCode`) VALUES ('{$this->idTag}', '{$data[3]->connectorId}', '{$data[3]->status}', '{$data[3]->errorCode}')"   );
    }

    //Get the user id who started the transaction
    public function UserTransactionId($transaction = 0)
    {
        if($transaction > 0)
        {
            $user = $this->db->row(" SELECT user_id FROM `my_user_start_transaction` WHERE `transactionId` = '{$transaction}' ");

            if(isset($user['user_id']) && $user['user_id'] > 0)
            {
                return $user['user_id'];
            }
            else {
                // If not found in start_transaction, try to get from session
                $session = $this->db->row("SELECT user_id FROM `my_sessions` WHERE `transactionId` = '{$transaction}' ORDER BY id DESC LIMIT 1");
                if(isset($session['user_id']) && $session['user_id'] > 0) {
                    $this->writeLog("UserTransactionId: Found user_id {$session['user_id']} from session for transaction {$transaction}");
                    return $session['user_id'];
                }

                $this->writeLog("UserTransactionId: Falling back to user_id 1 for transaction {$transaction}");
                return 1;
            }
        }
        else {
            return 1;
        }
    }


    //Write data from counters
    public function MeterValues($idTag, $data)
    {
        if ($data[2] !== 'MeterValues') { return; }

        if ($this->MeterValuesTransactionEnd($data)) {
            $this->writeLog('MeterValues: Transaction end');
            $this->writeLog(json_encode($data));
            $this->processEndMeterValues($idTag, $data);
            return;
        }

        $transactionId = $data[3]->transactionId;

        if ($transactionId > 0)
        {
            //$this->MeterValuesTransactionBegin($data, $idTag);
            $this->processMeterValues($idTag, $data, $transactionId);
            if (isset($data[3]->transactionId)) {
                $this->session->updateSessionStatus($data, $data[3]->transactionId);
            }
        }
        elseif ($transactionId == 0)
        {
            $this->resetTransaction($idTag);
        }

        $this->stopChargingIfBalanceIsLow($idTag, $transactionId);
    }

    private function processEndMeterValues($idTag, $data)
    {
        $transactionId = $data[3]->transactionId;
        if (!$transactionId) return;

        $unit_m = null;
        foreach ($data[3]->meterValue[0]->sampledValue as $sample) {
            if (isset($sample->measurand) && $sample->measurand === 'Energy.Active.Import.Register') {
                $unit_m = $sample->unit;
                break;
            }
        }

        if (!$unit_m) return;

        // Save final meter values like regular ones
        $this->StandardAlgorithm($data, $idTag, $unit_m);

        // Optionally: update session status to "ending"
        $this->db->query("
        UPDATE `my_sessions`
        SET status = 'ending', updated_at = NOW()
        WHERE transactionId = '{$transactionId}' AND status != 'finished'
    ");
    }


    private function MeterValuesTransactionBegin($data, $idTag)
    {
        if($data[2] == 'MeterValues')
        {
            $res = false;
            foreach ($data[3]->meterValue as $key => $value)
            {
                foreach ($value->sampledValue as $keys => $val)
                {
                    if(isset($val->context)  && $val->context == 'Transaction.Begin' && $val->measurand == 'Energy.Active.Import.Register')
                    {
                        $times = time();

                        $user = $this->UserTransactionId($data[3]->transactionId);

                        $this->db->query(  "INSERT INTO `my_charger_meter` (`userId`, `idTag`, `connectorId`, `transactionId`, `timestamp`) VALUES ('{$user}', '{$idTag}', '{$data[3]->connectorId}', '{$data[3]->transactionId}', '{$times}')"   );

                        $parentId = $this->db->lastInsertId();

                        $this->db->query(  "INSERT INTO `my_charger_meter_type`(`idTag`,`transactionId`, `parentId`, `value`, `measurand`,  `unit`)  VALUES  ('{$idTag}', '{$data[3]->transactionId}', '{$parentId}', '{$val->value}', '{$val->measurand}', '{$val->unit}')"   );
                    }
                }
            }
        }
    }


    private function MeterValuesTransactionEnd($data)
    {
        if($data[2] == 'MeterValues') {
            $res = false;
            foreach ($data[3]->meterValue as $key => $value) {
                foreach ($value->sampledValue as $keys => $val) {
                    if(isset($val->context)  && $val->context == 'Transaction.End') {
                        $res = true;
                    }
                }
            }
            return $res;
        } else {
            return false;
        }
    }


    private function processMeterValues($idTag, $data, $transactionId)
    {
        //Check the data, if MeterValues ​​is older than 24 hours then we do not write the data
        if (!$this->ChekTransactionId($data, $idTag)) {
            return;
        }

        //Determine Watt/Hr or Kilowatt/Hr
        $unit = null;
        foreach ($data[3]->meterValue[0]->sampledValue as $key => $value)
        {
            if(isset($value->measurand)  && $value->measurand == 'Energy.Active.Import.Register') {
                $unit = $value->unit;
            }
        }
        if($unit == null) { return; }

        $this->StandardAlgorithm($data, $idTag, $unit);

    }

    private function resetTransaction($idTag)
    {
        $row = $this->db->row("SELECT * FROM `my_set_command` WHERE idTag = '".$idTag."' AND type = 'Reset' ");
        if ($row === false) {
            $Reset = json_encode(array(0 => 2, 1 => ''.rand(1000000,9999999).'', 2 => 'Reset', array('type' => 'Hard')));
            $times = time();
            $this->db->row("INSERT INTO `my_set_command` (`idTag`, `user_id`, `type`, `text`, `heartbeat`) VALUES ('{$idTag}', NULL, 'Reset', '{$Reset}', '{$times}')");
        }
    }

    private function stopChargingIfBalanceIsLow($idTag, $transactionId)
    {
        $transaction_user = $this->db->row("SELECT user_id FROM `my_user_start_transaction` WHERE transactionId = '{$transactionId}' ");
        if($transaction_user)
        {
            $user = $this->db->row("SELECT * FROM `my_user` WHERE id = '".$transaction_user['user_id']."' AND stop = 0 ");

            // Make transaction stop if user balance is less than 5 // if they have 0.5 and they are charged their account will be -4.5
            if ($user && $user['balanse'] <= 5)
            {
                $row = $this->db->row("SELECT * FROM `my_set_command` WHERE idTag = '".$idTag."' AND type = 'RemoteStopTransaction' ");
                if ($row === false)
                {
                    $StopTransaction = json_encode(array(0 => 2, 1 => ''.rand(1000000,9999999).'', 2 => 'RemoteStopTransaction', array('transactionId' => $transactionId)));
                    $mobile = $user['mobile'];
                    $times = time();
                    $this->db->row("INSERT INTO `my_set_command` (`idTag`, `user_id`, `type`, `text`, `heartbeat`) VALUES ('{$idTag}', '{$mobile}', 'RemoteStopTransaction', '{$StopTransaction}', '{$times}')");
                }
            }
        }
    }


    public function NotStandardAlgorithm($data, $idTag, $zero, $unit_m)
    {
        //First of all, remove the fake MeterValues
        $this->db->query(" DELETE FROM `my_charger_meter_type` WHERE idTag ='".$idTag."' AND `transactionId` LIKE '".$data[3]->transactionId."' AND value = '0.00' AND `measurand` LIKE 'Energy.Active.Import.Register';  ");

        $times = time();

        //Determine who owns the session
        $user = $this->UserTransactionId($data[3]->transactionId);

        $this->db->query(  "INSERT INTO `my_charger_meter` (`userId`, `idTag`, `connectorId`, `transactionId`, `timestamp`) VALUES ('{$user}', '{$idTag}', '{$data[3]->connectorId}', '{$data[3]->transactionId}', '{$times}')"   );

        $parentId = $this->db->lastInsertId();

        //All other stations
        foreach ($data[3]->meterValue[0]->sampledValue as $key => $value)
        {
            if(isset($value->phase)) {$phase = $value->phase;} else { $phase = NULL;}
            if(isset($value->unit)) {$unit = $value->unit;} else { $unit = NULL;}

            if(isset($value->measurand)) {
                if($value->measurand == 'Energy.Active.Import.Register') {
                    $measurand = $value->measurand;
                    $value = $value->value - $zero;
                } else {
                    $measurand = $value->measurand;
                    $value = $value->value;
                }
            } else {
                $measurand = NULL;  $value = $value->value;
            }

            $this->db->query(  "INSERT INTO `my_charger_meter_type`(`idTag`,`transactionId`, `parentId`, `value`, `measurand`, `phase`, `unit`)  VALUES  ('{$idTag}', '{$data[3]->transactionId}', '{$parentId}', '{$value}', '{$measurand}', '{$phase}', '{$unit}')"   );
            $this->SetMoney($this->db->lastInsertId(), $unit_m);
        }
    }

    public function StandardAlgorithm($data, $idTag, $unit_m)
    {
        $times = time();
        //Determine who owns the session
        $user = $this->UserTransactionId($data[3]->transactionId);

        $this->db->query(  "INSERT INTO `my_charger_meter` (`userId`, `idTag`, `connectorId`, `transactionId`, `timestamp`) VALUES ('{$user}', '{$idTag}', '{$data[3]->connectorId}', '{$data[3]->transactionId}', '{$times}')"   );
        $parentId = $this->db->lastInsertId();

        foreach ($data[3]->meterValue[0]->sampledValue as $key => $value)
        {
            if(isset($value->phase)) {$phase = $value->phase;} else { $phase = NULL;}
            if(isset($value->unit)) {$unit = $value->unit;} else { $unit = NULL;}
            if(isset($value->measurand)) {$measurand = $value->measurand;} else { $measurand = NULL;}
            if(isset($value->value)) {$value = $value->value;} else { $value = NULL;}

            $this->db->query(  "INSERT INTO `my_charger_meter_type`(`idTag`,`transactionId`, `parentId`, `value`, `measurand`, `phase`, `unit`, `created_at`, `updated_at`)  VALUES  ('{$idTag}', '{$data[3]->transactionId}', '{$parentId}', '{$value}', '{$measurand}', '{$phase}', '{$unit}', NOW(), NOW())"   );

            $this->SetMoney($this->db->lastInsertId(), $unit_m);
        }
    }

    // Ticketing
    public function SetMoney($parent_id, $unit_m = null)
    {
        if ($parent_id <= 0) {
            return;
        }

        // Fetch current operation details
        $res = $this->db->row("SELECT * FROM `my_charger_meter_type` WHERE id = '{$parent_id}'");
        if (!$res || !isset($res['measurand'])) {
            $this->writeLog("Invalid or missing data for charger_meter_type with id: {$parent_id}");
            return;
        }

        if ($res['measurand'] !== 'Energy.Active.Import.Register') {
            return;
        }

        $times = time();
        $parentId = $res['parentId'];

        // Fetch parent details
        $parent_data = $this->db->row("SELECT * FROM `my_charger_meter` WHERE id = '{$parentId}'");
        if (!$parent_data) {
            $this->writeLog("Failed to fetch data for charger_meter with id: {$parentId}");
            return;
        }

        $transactionId = $parent_data['transactionId'];
        $idTag = $parent_data['idTag'];
        $connectorId = $parent_data['connectorId'];

        // Check if this is a fleet session
        $session = $this->db->row("
            SELECT s.*, fu.billing_type, f.balance as fleet_balance, f.company_id
            FROM my_sessions s
            LEFT JOIN fleet_users fu ON s.fleet_id = fu.fleet_id AND s.user_id = fu.user_id
            LEFT JOIN fleets f ON s.fleet_id = f.id
            WHERE s.transactionId = '{$transactionId}'
            ORDER BY s.id DESC
            LIMIT 1
        ");

        // Fetch previous counter value
        $old_t = $this->db->row("SELECT * FROM `my_charger_meter_type` WHERE transactionId = '{$transactionId}' AND idTag = '{$idTag}' AND measurand = 'Energy.Active.Import.Register' ORDER BY id DESC LIMIT 1, 1;");
        $old_value = $old_t['value'] ?? $res['value'];

        // Use session user_id if available, otherwise fallback to UserTransactionId
        $user_id = $session['user_id'] ?? $this->UserTransactionId($transactionId);
        $thisH = $res['value'] - $old_value;

        // Early return if no energy used
        if ($thisH <= 0) {
            return;
        }

        // Store the original value in the native unit (Wh or kWh)
        $original_thisH = $thisH;

        // Convert to kWh for pricing calculation and session storage
        $thisH_kwh = ($unit_m === 'Wh') ? $thisH / 1000 : $thisH;

        // Determine if this is a fleet session and get appropriate pricing
        $fleet_id = $session['fleet_id'] ?? null;
        $billing_type = $session['billing_type'] ?? 'individual';

        if ($fleet_id) {
            // Use fleet pricing
            $special = $this->pricing->getFleetPricing($idTag, $connectorId, $fleet_id, $user_id) ?? 0;
        } else {
            // Use regular pricing
            $special = $this->pricing->get($idTag, $connectorId, $user_id) ?? 0;
        }

        // Get standard cost per kW
        $connector = $this->db->row("SELECT * FROM `my_charger_connectorId` WHERE idTag = '{$idTag}' AND connectorId = '{$connectorId}'");
        $price_c = ($special > 0) ? $special : ($connector['price'] ?? 0);

        // Handle fleet billing vs regular billing
        if ($fleet_id && $billing_type === 'corporate') {
            // Fleet corporate billing - charge from fleet balance
            $price_m = $thisH_kwh * $price_c;

            // Check fleet balance
            $fleet_balance = (float)($session['fleet_balance'] ?? 0);
            if ($fleet_balance >= $price_m) {
                // Deduct from fleet balance
                $new_fleet_balance = $fleet_balance - $price_m;
                $this->db->query("UPDATE fleets SET balance = '{$new_fleet_balance}' WHERE id = '{$fleet_id}'");

                // Insert operation record with fleet information
                $this->db->query("
                    INSERT INTO `my_user_operations`
                    (`user_id`, `transactionId`, `operationTime`, `MeterValues`, `money`, `type`, `payment_type`, `energy_unit`, `user_balanse`, `fleet_id`, `billing_type`)
                    VALUES
                    ('{$user_id}', '{$transactionId}', '{$times}', '{$original_thisH}', '{$price_m}', 'charger', 'fleet_corporate', '{$unit_m}', '{$new_fleet_balance}', '{$fleet_id}', 'wallet')
                ");


                $this->session->setSessionCharging($transactionId, $idTag, $connectorId);
                $this->session->updateChargingValues($transactionId, $idTag, $connectorId, $thisH_kwh, $price_m);
            } else {
                $this->writeLog("Insufficient fleet balance for fleet ID {$fleet_id}. Required: {$price_m}, Available: {$fleet_balance}");
            }
        } else {
            // Regular individual billing or fleet individual billing
            // Use the Subscription class to handle charging
            $subscription_result = $this->subscription->handleChargingWithSubscription(
                $user_id,
                $idTag,
                $transactionId,
                $thisH_kwh, // Pass the kWh value for pricing
                $unit_m,
                $price_c
            );

            // Update my_user_operations based on subscription result
            if ($subscription_result['subscription_used']) {
                // If subscription was used (fully or partially)
                $money_to_charge = $subscription_result['balance_charge'];

                // Insert operation record with ORIGINAL value in native units
                $payment_type = $fleet_id ? 'fleet_individual' : $subscription_result['payment_type'];
                $billing_type_db = $fleet_id ? 'fleet_individual' : 'wallet';

                $this->db->query("
                INSERT INTO `my_user_operations`
                (`user_id`, `transactionId`, `operationTime`, `MeterValues`, `money`, `type`, `subscription_id`, `payment_type`, `energy_unit`, `fleet_id`, `billing_type`)
                VALUES
                ('{$user_id}', '{$transactionId}', '{$times}', '{$original_thisH}', '{$money_to_charge}', 'charger',
                 '{$subscription_result['subscription_id']}', '{$payment_type}', '{$unit_m}', " . ($fleet_id ? "'{$fleet_id}'" : 'NULL') . ", '{$billing_type_db}')
            ");

                // Only charge user balance if there's a balance charge
                if ($money_to_charge > 0) {
                    $operation_id = $this->db->lastInsertId();
                    $user_data = $this->db->row("SELECT balanse FROM `my_user` WHERE id = '{$user_id}' AND visible = '1'");

                    if ($user_data) {
                        $new_balance = $user_data['balanse'] - $money_to_charge;
                        $this->db->query("UPDATE `my_user` SET `balanse` = '{$new_balance}' WHERE id = '{$user_id}'");
                        $this->db->query("UPDATE `my_user_operations` SET `user_balanse` = '{$new_balance}' WHERE id = '{$operation_id}'");
                        $this->session->setSessionCharging($transactionId, $idTag, $connectorId);

                        // Always use kWh for session updates
                        $this->session->updateChargingValues($transactionId, $idTag, $connectorId, $thisH_kwh, $money_to_charge);
                    } else {
                        $this->writeLog("User with ID {$user_id} not found.");
                    }
                }
            } else {
                // If no subscription was used, charge directly from wallet
                $price_m = $thisH_kwh * $price_c;

                $payment_type = $fleet_id ? 'fleet_individual' : 'wallet';
                $billing_type_db = $fleet_id ? 'fleet_individual' : 'wallet';

                // Insert operation with ORIGINAL value in native units
                $this->db->query("
                INSERT INTO `my_user_operations`
                (`user_id`, `transactionId`, `operationTime`, `MeterValues`, `money`, `type`, `payment_type`, `energy_unit`, `fleet_id`, `billing_type`)
                VALUES
                ('{$user_id}', '{$transactionId}', '{$times}', '{$original_thisH}', '{$price_m}', 'charger', '{$payment_type}', '{$unit_m}', " . ($fleet_id ? "'{$fleet_id}'" : 'NULL') . ", '{$billing_type_db}')
            ");

                $operation_id = $this->db->lastInsertId();
                $user_data = $this->db->row("SELECT balanse FROM `my_user` WHERE id = '{$user_id}' AND visible = '1'");

                if ($user_data) {
                    $new_balance = $user_data['balanse'] - $price_m;
                    $this->db->query("UPDATE `my_user` SET `balanse` = '{$new_balance}' WHERE id = '{$user_id}'");
                    $this->db->query("UPDATE `my_user_operations` SET `user_balanse` = '{$new_balance}' WHERE id = '{$operation_id}'");
                    $this->session->setSessionCharging($transactionId, $idTag, $connectorId);

                    // Always use kWh for session updates
                    $this->session->updateChargingValues($transactionId, $idTag, $connectorId, $thisH_kwh, $price_m);
                } else {
                    $this->writeLog("User with ID {$user_id} not found.");
                }
            }
        }
    }

    // Special price for some users
//    public function SpecialMoney($idTag, $connectorId, $user_id)
//    {
//        //Get user number, aka login
//        $mobile = $this->db->row("SELECT mobile FROM `my_user` WHERE id = '{$user_id}'; ");
//
//        //Check if there is a special price for the user on this station and connector
//        $connector = $this->db->row("SELECT * FROM `my_charger_connectorId_special` WHERE idTag = '{$idTag}' AND connectorId = '{$connectorId}' AND user_id = '".$mobile['mobile']."' AND endcdate > '".time()."'  ; ");
//
//        if($connector)
//        {
//            return $connector['price'];
//        }
//    }

    //What type is this number
    public function SetType($type)
    {
        switch ($type)
        {
            case 'Heartbeat':
                $int = 1;
                break;

            case 'BootNotification':
                $int = 2;
                break;

            case 'StatusNotification':
                $int = 3;
                break;

            case 'StartTransaction':
                $int = 4;
                break;

            case 'StopTransaction':
                $int = 5;
                break;

            case 'RemoteStartTransaction':
                $int = 6;
                break;

            case 'RemoteStopTransaction':
                $int = 7;
                break;

            case 'MeterValues':
                $int = 8;
                break;

            case 'Authorize':
                $int = 9;
                break;

            case 'Reset':
                $int = 10;
                break;

            case 'UpdateFirmware':
                $int = 11;
                break;

            case 'GetDiagnostics':
                $int = 12;
                break;

            case 'DiagnosticsStatusNotification':
                $int = 13;
                break;

            case 'FirmwareStatusNotification':
                $int = 14;
                break;

            case 'TriggerMessage':
                $int = 15;
                break;

            case 'ChangeConfiguration':
                $int = 16;
                break;

            case 'GetConfiguration':
                $int = 17;
                break;

            case 'ClearCache':
                $int = 18;
                break;

            case 'ReserveNow':
                $int = 19;
                break;

            case 'CancelReservation':
                $int = 20;
                break;

            case 'UnlockConnector':
                $int = 21;
                break;

            case 'DataTransfer':
                $int = 22;
                break;

            case 'ChangeAvailability':
                $int = 23;
                break;

            case 'SecurityEventNotification':
                $int = 24;
                break;


            default:
                $int = 0;
                break;
        }

        return $int;
    }


    //Search for the Energy.Active.Import.Register value in the array
    public function searchForId($id, $array)
    {
        foreach ($array as $key => $val)
        {
            if(isset($val->measurand))
            {
                if ($val->measurand === $id)
                {
                    return $key;
                }
            }
        }
        return null;
    }

    public function handleRemoteStopTransaction($data) {
        if (isset($data[3]->transactionId)) {
            $this->session->endSessionIfExists($data[3]->transactionId);
            return true;
        }
        return false;
    }

    private function isRFIDAuthorized($idTag, $idTag_Authorize) {
        // Check global authorization
        $globalAuth = $this->db->row("
            SELECT * FROM `my_charger_authorize`
            WHERE idTag_Authorize = '{$idTag_Authorize}'
            AND is_global = 1
            AND deleted_at IS NULL
        ");

        if ($globalAuth) {
            return true;
        }

        // Check local authorization
        $localAuth = $this->db->row("
            SELECT * FROM `my_charger_authorize`
            WHERE idTag = '{$idTag}'
            AND idTag_Authorize = '{$idTag_Authorize}'
            AND is_global = 0
            AND deleted_at IS NULL
        ");

        return $localAuth ? true : false;
    }

    public function writeLog($message) {
        // Skip logging if not in debug mode - data is already saved to database
        if (!$this->debug_mode) {
            return;
        }

        $logFile = __DIR__ . '/debug.log';
        $timestamp = date('Y-m-d H:i:s');
        file_put_contents($logFile, "[$timestamp] $message\n", FILE_APPEND);
    }

    /**
     * Handle VehicleMAC DataTransfer from BENY chargers for fleet charging
     */
    private function handleVehicleMACDataTransfer($idTag, $data, $dataStr) {
        try {
            // Fix malformed JSON - timestamp might be missing quotes
            // Replace unquoted timestamp pattern with quoted version
            $dataStr = preg_replace('/"timestamp":([^"}]+)/', '"timestamp":"$1"', $dataStr);
            
            // Parse the JSON data containing vehicle information
            $vehicleData = json_decode($dataStr, true);

            if (!$vehicleData || !isset($vehicleData['vehicleId'])) {
                $this->writeLog("Invalid vehicle data: $dataStr");
                return json_encode([
                    3,
                    $data[1],
                    ['status' => 'Rejected']
                ]);
            }

            $vehicleId = $vehicleData['vehicleId']; // This is the VIN
            $connectorId = $vehicleData['connectorId'] ?? 1;

            $this->writeLog("Fleet vehicle detected - VIN: $vehicleId, Connector: $connectorId");

            // Check if this vehicle is authorized (fleet vehicle)
            $isFleetVehicle = $this->checkFleetVehicleAuthorization($vehicleId, $idTag);

            if ($isFleetVehicle) {
                $this->writeLog("Fleet vehicle authorized: $vehicleId");

                // Get fleet information
                $fleetInfo = $this->getFleetInfoByVIN($vehicleId);
                if (!$fleetInfo) {
                    return json_encode([
                        3,
                        $data[1],
                        ['status' => 'Rejected', 'data' => 'Vehicle not found, inactive, or no custodian assigned']
                    ]);
                }

                // Start automatic charging for fleet vehicle
                $this->startFleetCharging($idTag, $connectorId, $vehicleId, $fleetInfo);

                return json_encode([
                    3,
                    $data[1],
                    ['status' => 'Accepted']
                ]);
            } else {
                $this->writeLog("Vehicle not authorized: $vehicleId");
                return json_encode([
                    3,
                    $data[1],
                    ['status' => 'Rejected', 'data' => 'Vehicle not authorized']
                ]);
            }

        } catch (\Exception $e) {
            $this->writeLog("Error handling VehicleMAC: " . $e->getMessage());
            return json_encode([
                3,
                $data[1],
                [
                    'status' => 'UnknownVendorId',
                    'error' => $e->getMessage()
                ]
            ]);
        }
    }

    /**
     * Check if vehicle VIN is authorized as a fleet vehicle
     */
    private function checkFleetVehicleAuthorization($vin, $idTag) {
        // Check if this VIN belongs to a fleet vehicle
        $vehicle = $this->db->row("
            SELECT v.*, fv.fleet_id, f.name as fleet_name, f.company_id
            FROM vehicles v
            INNER JOIN fleet_vehicles fv ON v.id = fv.vehicle_id
            INNER JOIN fleets f ON fv.fleet_id = f.id
            WHERE v.vin = '{$vin}'
            AND v.deleted_at IS NULL
            AND fv.deleted_at IS NULL
            AND f.deleted_at IS NULL
            AND f.status = 'Active'
            LIMIT 1
        ");

        if (!$vehicle) {
            $this->writeLog("Vehicle not found or not part of an active fleet: $vin");
            return false;
        }

        // If vehicle belongs to an active fleet, it's automatically authorized
        $this->writeLog("Vehicle {$vin} belongs to fleet '{$vehicle['fleet_name']}' - authorized");
        return true;
    }

    /**
     * Get fleet information by VIN
     */
    private function getFleetInfoByVIN($vin) {
        // Get vehicle and fleet info including fleet balance
        $vehicleInfo = $this->db->row("
            SELECT v.*, fv.fleet_id, f.company_id, f.name as fleet_name, f.balance as fleet_balance
            FROM vehicles v
            INNER JOIN fleet_vehicles fv ON v.id = fv.vehicle_id
            INNER JOIN fleets f ON fv.fleet_id = f.id
            WHERE v.vin = '{$vin}'
            AND v.deleted_at IS NULL
            AND fv.deleted_at IS NULL
            AND f.deleted_at IS NULL
            AND f.status = 'Active'
            LIMIT 1
        ");

        if (!$vehicleInfo || !$vehicleInfo['fleet_id']) {
            $this->writeLog("Fleet vehicle not found or inactive for VIN: {$vin}");
            return null;
        }

        // Check if vehicle has an assigned custodian
        $custodian = $this->db->row("
            SELECT fvc.user_id, u.balanse as user_balance, u.company_id
            FROM fleet_vehicle_custodians fvc
            INNER JOIN my_user u ON fvc.user_id = u.id
            WHERE fvc.vehicle_id = '{$vehicleInfo['id']}'
            AND fvc.deleted_at IS NULL
            AND u.visible = 1
            LIMIT 1
        ");

        if (!$custodian) {
            $this->writeLog("Vehicle {$vin} (ID: {$vehicleInfo['id']}) has no assigned custodian - charging rejected");
            return null;
        }

        $vehicleInfo['custodian_user_id'] = $custodian['user_id'];
        $this->writeLog("Vehicle {$vin} custodian found: user_id {$custodian['user_id']}");

        // Get fleet user configuration to determine billing type
        $fleetUser = $this->db->row("
            SELECT fu.*, u.id as user_id, u.balanse as user_balance, u.company_id
            FROM fleet_users fu
            LEFT JOIN my_user u ON fu.user_id = u.id
            WHERE fu.fleet_id = '{$vehicleInfo['fleet_id']}'
            AND fu.user_id = '{$custodian['user_id']}'
            LIMIT 1
        ");

        // If corporate billing, use fleet balance and company user ID
        if ($fleetUser && $fleetUser['billing_type'] === 'corporate') {
            $companyUser = $this->db->row("
                SELECT id, balanse, company_id
                FROM my_user
                WHERE company_id = '{$vehicleInfo['company_id']}'
                ORDER BY id ASC
                LIMIT 1
            ");

            if ($companyUser) {
                $vehicleInfo['billing_user_id'] = $custodian['user_id']; // Use custodian as the user
                $vehicleInfo['billing_balance'] = $vehicleInfo['fleet_balance']; // Use fleet balance for corporate billing
                $vehicleInfo['billing_type'] = 'corporate';
                $this->writeLog("Corporate billing configured for vehicle {$vin} - Fleet balance: {$vehicleInfo['fleet_balance']}");
            }
        } else if ($fleetUser) {
            // Personal billing - use individual user balance
            $vehicleInfo['billing_user_id'] = $custodian['user_id'];
            $vehicleInfo['billing_balance'] = $custodian['user_balance'];
            $vehicleInfo['billing_type'] = 'individual';
            $this->writeLog("Individual billing configured for vehicle {$vin} - User balance: {$custodian['user_balance']}");
        } else {
            // Custodian exists but not in fleet_users - reject
            $this->writeLog("Vehicle {$vin} custodian {$custodian['user_id']} is not a fleet user - charging rejected");
            return null;
        }

        return $vehicleInfo;
    }

    /**
     * Start automatic charging for fleet vehicle
     */
    private function startFleetCharging($idTag, $connectorId, $vin, $fleetInfo) {
        $transactionId = $this->generateTransactionId();
        $timestamp = time();
        $userId = $fleetInfo['billing_user_id'] ?? 1;

        // Get pricing using the existing Pricing instance for fleet-specific pricing
        $price = $this->pricing->getFleetPricing($idTag, $connectorId, $fleetInfo['fleet_id'], $userId);

        // Ensure we have a valid price, fallback to connector price if needed
        if (!$price || $price <= 0) {
            $connector = $this->db->row("SELECT price FROM my_charger_connectorId WHERE idTag = '{$idTag}' AND connectorId = '{$connectorId}' ORDER BY id DESC LIMIT 1");
            $price = $connector['price'] ?? 5.00; // Default fallback price
            $this->writeLog("Fleet pricing fallback: Using connector price {$price} for idTag {$idTag}, connectorId {$connectorId}");
        }

        // Get connector profile for other details like session_fee
        $currentTime = date('H:i:s');
        $connectorProfile = $this->db->row("
            SELECT * FROM my_charger_connector_profile
            WHERE idTag = '{$idTag}'
            AND connectorId = '{$connectorId}'
            AND TIME('{$currentTime}') BETWEEN start_time AND end_time
            ORDER BY id DESC
            LIMIT 1
        ");

        if (!$connectorProfile) {
            // Use default pricing if no profile found
            $connectorProfile = [
                'price' => $price,
                'gross_price' => $price,
                'session_fee' => 0
            ];
        } else {
            // Use fleet-specific pricing but keep other profile settings
            $connectorProfile['price'] = $price;
            $connectorProfile['gross_price'] = $price;
        }

        $this->writeLog("Fleet session created with pricing: price={$price}, gross_price={$connectorProfile['gross_price']}");

        $sessionFee = $connectorProfile['session_fee'] ?? 0;

        // Create session record
        $this->db->query("
            INSERT INTO my_sessions (
                transactionId, connectorId, idTag, user_id,
                vehicle_id, fleet_id, gross_price, session_fee,
                total_energy, total_cost, session_fee_paid,
                status, created_at, updated_at
            ) VALUES (
                '{$transactionId}', '{$connectorId}', '{$idTag}', '{$userId}',
                '{$fleetInfo['id']}', '{$fleetInfo['fleet_id']}', '{$connectorProfile['gross_price']}', '{$sessionFee}',
                0, 0, 0,
                'starting', NOW(), NOW()
            )
        ");

        // Get the session ID
        $sessionId = $this->db->lastInsertId();


        // Create StartTransaction record in history
        $this->db->query("
            INSERT INTO my_user_start_transaction (
                user_id, transactionId, TimeCompletion, created_at
            ) VALUES (
                '{$userId}', '{$transactionId}', '{$timestamp}', NOW()
            )
        ");

        // Send Authorize command to the charger (as per manufacturer requirement)
        $authorizeCommand = [
            2,
            (string)rand(1000000, 9000000),
            'Authorize',
            [
                'idTag' => $idTag  // Use the charger's idTag for authorization
            ]
        ];
        
        $this->db->query("
            INSERT INTO my_set_command (
                idTag, user_id, type, text, heartbeat
            ) VALUES (
                '{$idTag}', '{$userId}', 'Authorize',
                '" . json_encode($authorizeCommand) . "', '{$timestamp}'
            )
        ");
        
        $this->writeLog("Fleet session prepared and Authorize sent - Transaction: $transactionId, VIN: $vin, User: $userId");
    }

    /**
     * Generate a unique transaction ID
     * Uses a 7-digit number to ensure compatibility with database column constraints
     */
    private function generateTransactionId()
    {
        // Generate a 7-digit transaction ID (10000000 to 99999999)
        $transactionId = rand(1000000,9999999);

        // Ensure we don't have collisions by checking database
        $existing = $this->db->row("SELECT id FROM my_user_start_transaction WHERE transactionId = '{$transactionId}' LIMIT 1");

        if ($existing) {
            // If collision, try again with different random number
            return $this->generateTransactionId();
        }

        return $transactionId;
    }

}
