<?php
namespace MyApp;

class Pricing
{
    private $db;

    public function __construct($db)
    {
        $this->db = $db;
    }

    public function getSpecialPricing($idTag, $connectorId, $user_id)
    {
        $current_time = date('H:i:s');

        // Check for custom price through group membership
        $groupSql = "
            SELECT cp.price, cp.id as profile_id
            FROM custom_connector_profiles cp
            JOIN profile_assignments pa ON pa.custom_profile_id = cp.id
            JOIN custom_group_users cgu ON cgu.custom_group_id = pa.assignable_id
            WHERE cp.idTag = '{$idTag}'
            AND cp.connectorId = '{$connectorId}'
            AND TIME('{$current_time}') BETWEEN cp.start_time AND cp.end_time
            AND pa.status = 'active'
            AND pa.assignable_type LIKE '%CustomGroup%'
            AND cgu.user_id = '{$user_id}'
            ORDER BY cp.id DESC
            LIMIT 1
        ";

        $groupResult = $this->db->row($groupSql);

        if ($groupResult && isset($groupResult['price'])) {
            // error_log("Group pricing found: price={$groupResult['price']}, profile_id={$groupResult['profile_id']} for user_id={$user_id}, idTag={$idTag}, connectorId={$connectorId}");
            return $groupResult['price'];
        }

        // If no group price, try direct user assignment
        $userSql = "
            SELECT cp.price, cp.id as profile_id
            FROM custom_connector_profiles cp
            JOIN profile_assignments pa ON pa.custom_profile_id = cp.id
            WHERE cp.idTag = '{$idTag}'
            AND cp.connectorId = '{$connectorId}'
            AND TIME('{$current_time}') BETWEEN cp.start_time AND cp.end_time
            AND pa.status = 'active'
            AND pa.assignable_type LIKE '%Customer%'
            AND pa.assignable_id = '{$user_id}'
            ORDER BY cp.id DESC
            LIMIT 1
        ";

        $userResult = $this->db->row($userSql);

        if ($userResult && isset($userResult['price'])) {
            // error_log("User pricing found: price={$userResult['price']}, profile_id={$userResult['profile_id']} for user_id={$user_id}, idTag={$idTag}, connectorId={$connectorId}");
            return $userResult['price'];
        }

        // Finally try standard pricing from connector profile
        $standardSql = "
            SELECT price, id as profile_id
            FROM my_charger_connector_profile
            WHERE idTag = '{$idTag}'
            AND connectorId = '{$connectorId}'
            AND TIME('{$current_time}') BETWEEN start_time AND end_time
            ORDER BY id DESC
            LIMIT 1
        ";

        $standardResult = $this->db->row($standardSql);
        
        if ($standardResult && isset($standardResult['price'])) {
            // error_log("Standard connector profile pricing found: price={$standardResult['price']}, profile_id={$standardResult['profile_id']} for idTag={$idTag}, connectorId={$connectorId}");
            return $standardResult['price'];
        }

        // If no connector profile found, fall back to connector pricing
        $connectorSql = "
            SELECT price, id as connector_id
            FROM my_charger_connectorId
            WHERE idTag = '{$idTag}'
            AND connectorId = '{$connectorId}'
            ORDER BY id DESC
            LIMIT 1
        ";

        $connectorResult = $this->db->row($connectorSql);
        
        if ($connectorResult && isset($connectorResult['price'])) {
            // error_log("Connector fallback pricing found: price={$connectorResult['price']}, connector_id={$connectorResult['connector_id']} for idTag={$idTag}, connectorId={$connectorId}");
            return $connectorResult['price'];
        }

        // error_log("No pricing found for idTag={$idTag}, connectorId={$connectorId}, user_id={$user_id}");
        return 0;
    }

    /**
     * Wrapper method for getSpecialPricing
     */
    public function get($idTag, $connectorId, $user_id)
    {
        return $this->getSpecialPricing($idTag, $connectorId, $user_id);
    }

    /**
     * Get pricing for fleet vehicles with fleet-specific custom pricing
     * For fleet vehicles, we ONLY check fleet assignments and standard pricing - NO individual user assignments
     */
    public function getFleetPricing($idTag, $connectorId, $fleet_id, $user_id)
    {
        $current_time = date('H:i:s');

        // First check for fleet-specific custom pricing
        $fleetSql = "
            SELECT cp.price
            FROM custom_connector_profiles cp
            JOIN profile_assignments pa ON pa.custom_profile_id = cp.id
            WHERE cp.idTag = '{$idTag}'
            AND cp.connectorId = '{$connectorId}'
            AND TIME('{$current_time}') BETWEEN cp.start_time AND cp.end_time
            AND pa.status = 'active'
            AND pa.assignable_type LIKE '%Fleet%'
            AND pa.assignable_id = '{$fleet_id}'
            ORDER BY cp.id DESC
            LIMIT 1
        ";

        $fleetResult = $this->db->row($fleetSql);

        if ($fleetResult && isset($fleetResult['price'])) {
            // error_log("Fleet pricing found: price={$fleetResult['price']} for fleet_id={$fleet_id}, idTag={$idTag}, connectorId={$connectorId}");
            return $fleetResult['price'];
        }

        // error_log("No fleet pricing found for fleet_id={$fleet_id}, falling back to standard pricing (skipping user assignments)");
        
        // For fleet vehicles, skip individual user assignments and go straight to standard pricing
        // Try standard pricing from connector profile
        $standardSql = "
            SELECT price, id as profile_id
            FROM my_charger_connector_profile
            WHERE idTag = '{$idTag}'
            AND connectorId = '{$connectorId}'
            AND TIME('{$current_time}') BETWEEN start_time AND end_time
            ORDER BY id DESC
            LIMIT 1
        ";

        $standardResult = $this->db->row($standardSql);
        
        if ($standardResult && isset($standardResult['price'])) {
            // error_log("Fleet fallback: Standard connector profile pricing found: price={$standardResult['price']}, profile_id={$standardResult['profile_id']} for idTag={$idTag}, connectorId={$connectorId}");
            return $standardResult['price'];
        }

        // If no connector profile found, fall back to connector pricing
        $connectorSql = "
            SELECT price, id as connector_id
            FROM my_charger_connectorId
            WHERE idTag = '{$idTag}'
            AND connectorId = '{$connectorId}'
            ORDER BY id DESC
            LIMIT 1
        ";

        $connectorResult = $this->db->row($connectorSql);
        
        if ($connectorResult && isset($connectorResult['price'])) {
            // error_log("Fleet fallback: Connector pricing found: price={$connectorResult['price']}, connector_id={$connectorResult['connector_id']} for idTag={$idTag}, connectorId={$connectorId}");
            return $connectorResult['price'];
        }

        // error_log("No pricing found for fleet vehicle - fleet_id={$fleet_id}, idTag={$idTag}, connectorId={$connectorId}");
        return 0;
    }

    /**
     * Check if a user belongs to a specific group
     */
    public function isUserInGroup($user_id, $group_id)
    {
        $sql = "
            SELECT id FROM custom_group_users
            WHERE user_id = '{$user_id}'
            AND custom_group_id = '{$group_id}'
        ";

        $result = $this->db->row($sql);

        return !empty($result);
    }

    /**
     * Check if a fleet has specific pricing assigned
     */
    public function isFleetHasCustomPricing($fleet_id, $idTag, $connectorId)
    {
        $current_time = date('H:i:s');
        
        $sql = "
            SELECT cp.id
            FROM custom_connector_profiles cp
            JOIN profile_assignments pa ON pa.custom_profile_id = cp.id
            WHERE cp.idTag = '{$idTag}'
            AND cp.connectorId = '{$connectorId}'
            AND TIME('{$current_time}') BETWEEN cp.start_time AND cp.end_time
            AND pa.status = 'active'
            AND pa.assignable_type LIKE '%Fleet%'
            AND pa.assignable_id = '{$fleet_id}'
        ";

        $result = $this->db->row($sql);

        return !empty($result);
    }
}
