<?php
namespace MyApp;

class Session
{
    private $db;

    public function __construct($db)
    {
        $this->db = $db;
    }

    /**
     * Update session status by transactionId
     */
    public function updateSessionStatus($data = null, $transactionId = null, $status = null)
    {
        if (is_numeric($data) && $transactionId === null) {
            $transactionId = $data;
        }

        if (!$transactionId || !$status) {
            return;
        }

        $this->db->query("
            UPDATE `my_sessions`
            SET status = '{$status}',
                updated_at = NOW()
            WHERE transactionId = '{$transactionId}'
            LIMIT 1
        ");
    }

    public function endSessionIfExists($transactionId, $idTag = null, $connectorId = null)
    {
        $session = $this->db->row("
            SELECT * FROM `my_sessions`
            WHERE transactionId = '{$transactionId}'
            LIMIT 1
        ");

        if ($session) {
            $this->updateSessionStatus($transactionId, null, 'finished');
        }
    }

    public function setTransactionIdForSession($transactionId, $idTag, $connectorId) {
        if (!isset($transactionId)) {
            return;
        }

        $this->db->query("
            UPDATE `my_sessions`
            SET transactionId = '{$transactionId}'
            WHERE idTag = '{$idTag}'
            AND connectorId = '{$connectorId}'
            ORDER BY id DESC
            LIMIT 1
        ");
    }

    public function setSessionStarting($transactionId, $idTag, $connectorId)
    {
        $this->db->query("
        UPDATE `my_sessions`
        SET status = 'starting', updated_at = NOW()
        WHERE transactionId = '{$transactionId}'
          AND idTag = '{$idTag}'
          AND connectorId = '{$connectorId}'
        ORDER BY id DESC
        LIMIT 1
    ");
    }

    public function setSessionCharging($transactionId, $idTag, $connectorId)
    {
        $this->db->query("
        UPDATE `my_sessions`
        SET status = 'charging', updated_at = NOW()
            WHERE transactionId = '{$transactionId}'
              AND idTag = '{$idTag}'
              AND connectorId = '{$connectorId}'
            ORDER BY id DESC
            LIMIT 1
        ");

        $this->deductSessionFee($transactionId, $idTag, $connectorId);
    }

    public function updateChargingValues($transactionId, $idTag, $connectorId, $thisH, $price_m) {
        $this->db->query("
        UPDATE `my_sessions`
        SET total_energy = IFNULL(total_energy, 0) + '{$thisH}',
            total_cost = IFNULL(total_cost, 0) + '{$price_m}',
            updated_at = NOW()
        WHERE transactionId = '{$transactionId}'
        AND idTag = '{$idTag}'
        AND connectorId = '{$connectorId}'
        ORDER BY id DESC
        LIMIT 1
    ");
    }

    private function deductSessionFee($transactionId, $idTag, $connectorId)
    {
        $session = $this->db->row("
            SELECT s.*, fu.billing_type, f.balance as fleet_balance
            FROM my_sessions s
            LEFT JOIN fleet_users fu ON s.fleet_id = fu.fleet_id AND s.user_id = fu.user_id
            LEFT JOIN fleets f ON s.fleet_id = f.id
            WHERE s.transactionId = '{$transactionId}'
              AND s.idTag = '{$idTag}'
              AND s.connectorId = '{$connectorId}'
            ORDER BY s.id DESC
            LIMIT 1
        ");

        if (!$session || $session['session_fee_paid']) {return;} // EARLY RETURN

        $userId = $session['user_id'] ?? null;
        $sessionFee = (float) ($session['session_fee'] ?? 0);
        $fleetId = $session['fleet_id'] ?? null;
        $billingType = $session['billing_type'] ?? 'individual';

        if (!$userId) {return;}

        // Case 1: Free session, always mark as paid
        if ($sessionFee == 0) {
            $this->db->query("
            UPDATE my_sessions
            SET session_fee_paid = 1, updated_at = NOW()
            WHERE id = '{$session['id']}'
            LIMIT 1
        ");
            return;
        }

        $now = time();

        // Case 2: Fleet corporate billing - deduct from fleet balance
        if ($fleetId && $billingType === 'corporate') {
            $fleetBalance = (float) ($session['fleet_balance'] ?? 0);
            
            if ($fleetBalance >= $sessionFee) {
                $newFleetBalance = $fleetBalance - $sessionFee;
                
                // Update fleet balance
                $this->db->query("UPDATE fleets SET balance = '{$newFleetBalance}' WHERE id = '{$fleetId}'");
                
                // Insert session_fee operation with fleet info
                $this->db->query("
                    INSERT INTO my_user_operations
                    (user_id, transactionId, operationTime, MeterValues, money, type, payment_type, energy_unit, user_balanse, fleet_id, billing_type)
                    VALUES
                    ('{$userId}', '{$transactionId}', '{$now}', 0, '{$sessionFee}', 'session_fee', 'fleet_corporate', NULL, '{$newFleetBalance}', '{$fleetId}', 'wallet')
                ");
                

                // Mark session as paid
                $this->db->query("
                UPDATE my_sessions
                SET session_fee_paid = 1, updated_at = NOW()
                WHERE id = '{$session['id']}'
                LIMIT 1
            ");
            }
        } else {
            // Case 3: Individual billing (regular or fleet individual)
            $user = $this->db->row("
                SELECT balanse FROM my_user
                WHERE id = '{$userId}' AND visible = 1
                LIMIT 1
            ");

            if (!$user) { return; } // EARLY RETURN

            $userBalance = (float) $user['balanse'];
            $newBalance = $userBalance - $sessionFee;

            if ($newBalance >= 5) {
                $paymentType = $fleetId ? 'fleet_individual' : 'wallet';
                $billingTypeDb = $fleetId ? 'fleet_individual' : 'wallet';
                
                // Insert session_fee operation
                $this->db->query("
                    INSERT INTO my_user_operations
                    (user_id, transactionId, operationTime, MeterValues, money, type, payment_type, energy_unit, user_balanse, fleet_id, billing_type)
                    VALUES
                    ('{$userId}', '{$transactionId}', '{$now}', 0, '{$sessionFee}', 'session_fee', '{$paymentType}', NULL, '{$newBalance}', " . ($fleetId ? "'{$fleetId}'" : 'NULL') . ", '{$billingTypeDb}')
                ");

                // Deduct from balance
                $this->db->query("
                    UPDATE my_user
                    SET balanse = '{$newBalance}'
                    WHERE id = '{$userId}'
                    LIMIT 1
                ");

                // Mark session as paid
                $this->db->query("
                UPDATE my_sessions
                SET session_fee_paid = 1, updated_at = NOW()
                WHERE id = '{$session['id']}'
                LIMIT 1
            ");
            }
        }
    }

    public function linkUserToCompany($idTag, $userId)
    {
        $charger = $this->db->row("SELECT company_id FROM my_charger WHERE idTag = '{$idTag}' LIMIT 1");

        if ($charger && $charger['company_id']) {
            $exists = $this->db->row("
            SELECT id FROM my_company_customers
            WHERE company_id = '{$charger['company_id']}'
              AND user_id = '{$userId}'
            LIMIT 1
        ");

            if (!$exists) {
                $now = time();
                $this->db->query("
                INSERT INTO my_company_customers (company_id, user_id, created_at, updated_at)
                VALUES ('{$charger['company_id']}', '{$userId}', FROM_UNIXTIME({$now}), FROM_UNIXTIME({$now}))
            ");
            }
        }
    }

}
